<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Thickness extends Model 
{

    protected $table = 'thicknesses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function services()
    {
        return $this->belongsToMany('Service', 'service_thickness', 'thickness_id', 'service_id')->withTimestamps();
    }

    public function materials()
    {
        return $this->belongsToMany('Material', 'material_thickness', 'thickness_id', 'material_id')->withTimestamps();
    }

}